-- Create a table to store public profile information
CREATE TABLE public.profiles (
    id UUID REFERENCES auth.users(id) ON DELETE CASCADE PRIMARY KEY,
    full_name TEXT,
    email TEXT UNIQUE, -- Adding email here for simplicity, though it duplicates auth.users
    role TEXT DEFAULT 'client',
    status TEXT DEFAULT 'active',
    created_at TIMESTAMP WITH TIME ZONE DEFAULT NOW(),
    updated_at TIMESTAMP WITH TIME ZONE DEFAULT NOW()
);

-- Enable Row Level Security (RLS) for the profiles table
ALTER TABLE public.profiles ENABLE ROW LEVEL SECURITY;

-- Create a policy to allow all public, anonymous, and authenticated users to read profiles
CREATE POLICY "Allow public read access to profiles" ON public.profiles
FOR SELECT
TO public, anon, authenticated
USING (true);
