<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>The ONYX by MEER Group</title>

    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700;800&display=swap" rel="stylesheet">

    
    <script src="https://cdn.tailwindcss.com"></script>

    <style>
        /* Accent color updated to match provided theme (ONYX orange) */
        .text-accent { color: #f57c00; }
        .bg-accent { background-color: #f57c00; }
        .hover-bg-accent:hover { background-color: #e56f00; }
        .hover-text-accent:hover { color: #f57c00; }
        /* Subtle dark pattern */
        .bg-onyx {
            background:
                radial-gradient(1000px 400px at 50% -20%, rgba(245,124,0,0.15), transparent 60%),
                radial-gradient(800px 300px at 120% 10%, rgba(245,124,0,0.08), transparent 70%),
                #0a0a0a;
        }
        .glass {
            background: rgba(255,255,255,0.02);
            border: 1px solid rgba(255,255,255,0.08);
            backdrop-filter: blur(6px);
        }
        .btn {
            @apply inline-flex items-center justify-center rounded-full px-6 py-3 font-semibold transition;
        }
        .btn-primary {
            @apply text-white;
            background-color: #f57c00;
        }
        .btn-primary:hover { background-color: #e56f00; }
        .btn-secondary {
            @apply text-white border border-neutral-700;
            background-color: transparent;
        }
        .btn-secondary:hover { border-color: #f57c00; color: #ffffff; }
    </style>
</head>
<body class="bg-onyx text-white" style="font-family: Inter, ui-sans-serif, system-ui, -apple-system, Segoe UI, Roboto, Helvetica, Arial;">

    
    <header class="flex items-center justify-between px-8 py-5 bg-accent text-white sticky top-0 z-50 shadow-lg">
        <h1 class="text-2xl font-bold tracking-wide">THE ONYX</h1>
        <nav class="space-x-8">
            <a href="#about" class="hover:underline underline-offset-4 transition">About</a>
            <a href="#features" class="hover:underline underline-offset-4 transition">Features</a>
            <a href="#contact" class="hover:underline underline-offset-4 transition">Contact</a>
            <a href="#booking" class="bg-white text-black font-semibold px-4 py-2 rounded-full hover:bg-neutral-100 transition shadow">Book Now</a>
        </nav>
    </header>

    
    <section class="relative h-[85vh] bg-cover bg-center flex flex-col items-center justify-center text-center" style="background-image: url('/images/onyx-bg.jpg');">
        <div class="absolute inset-0 bg-gradient-to-b from-black/70 via-black/70 to-black/80"></div>
        <div class="relative z-10 px-6">
            <h2 class="text-5xl md:text-6xl font-extrabold text-white drop-shadow mb-4">Luxury Living at <span class="text-accent">The ONYX</span></h2>
            <p class="text-lg md:text-xl text-gray-200 max-w-3xl mx-auto mb-10">
                Experience the finest lifestyle in the heart of Galiyat — premium apartments and penthouses by MEER Group.
            </p>
            <div class="flex flex-col sm:flex-row gap-4 justify-center">
                <a href="<?php echo e(route('login')); ?>" class="btn btn-primary shadow-lg shadow-accent/20">Reserve Your Unit</a>
                <a href="#about" class="btn btn-secondary">Learn More</a>
            </div>
            <div class="mt-10 flex flex-wrap items-center justify-center gap-6 text-sm text-gray-300">
                <div class="glass px-4 py-2 rounded-full">Secure Ownership</div>
                <div class="glass px-4 py-2 rounded-full">Scenic Galiyat Views</div>
                <div class="glass px-4 py-2 rounded-full">Premium Finishes</div>
            </div>
        </div>
    </section>

    
    <section id="about" class="py-20 bg-neutral-950 text-center">
        <h2 class="text-3xl md:text-4xl font-semibold text-accent mb-6">About The ONYX</h2>
        <p class="max-w-4xl mx-auto text-gray-300 leading-relaxed px-6">
            The ONYX by <span class="text-accent font-semibold">MEER Onyx Developments (Pvt.) Ltd.</span> 
            is a premium residential project nestled in Kuza Gali Galiyat, KPK, Pakistan. 
            Offering luxurious apartments and penthouses on an ownership basis, The ONYX redefines modern living with 
            elegance, exclusivity, and breathtaking natural surroundings.
        </p>
    </section>

    
    <section id="features" class="py-24 bg-black">
        <div class="container mx-auto px-6 grid md:grid-cols-3 gap-8">
            <div class="glass rounded-2xl p-8 hover:border-accent/40 transition border border-neutral-800">
                <h3 class="text-2xl text-accent font-semibold mb-3">🏙 Luxury Apartments</h3>
                <p class="text-gray-400">Meticulously designed spaces that combine comfort and sophistication with high‑end finishes.</p>
            </div>
            <div class="glass rounded-2xl p-8 hover:border-accent/40 transition border border-neutral-800">
                <h3 class="text-2xl text-accent font-semibold mb-3">📍 Prime Location</h3>
                <p class="text-gray-400">Located in the serene beauty of Galiyat, providing peaceful views and refreshing mountain air.</p>
            </div>
            <div class="glass rounded-2xl p-8 hover:border-accent/40 transition border border-neutral-800">
                <h3 class="text-2xl text-accent font-semibold mb-3">🏗 Trusted Developer</h3>
                <p class="text-gray-400">Developed by MEER Onyx Developments (Pvt.) Ltd., ensuring premium quality and transparent dealings.</p>
            </div>
        </div>
    </section>

    
    <section class="py-24 bg-neutral-950">
        <div class="container mx-auto px-6 grid lg:grid-cols-2 gap-12 items-center">
            <div class="overflow-hidden rounded-2xl border border-neutral-800 shadow-xl">
                <img src="/images/onyx-interior.jpg" alt="The ONYX Interior" class="w-full h-full object-cover">
            </div>
            <div>
                <h3 class="text-3xl font-semibold mb-4">Designed for comfort, crafted for elegance</h3>
                <p class="text-gray-300 mb-6">Spacious layouts, floor‑to‑ceiling windows, and premium materials create a refined living experience with breathtaking panoramas.</p>
                <ul class="space-y-3">
                    <li class="flex items-start gap-3"><span class="mt-1 h-2 w-2 rounded-full bg-accent"></span><span class="text-gray-300">Modern kitchens with high‑end fittings</span></li>
                    <li class="flex items-start gap-3"><span class="mt-1 h-2 w-2 rounded-full bg-accent"></span><span class="text-gray-300">Private balconies overlooking scenic Galiyat</span></li>
                    <li class="flex items-start gap-3"><span class="mt-1 h-2 w-2 rounded-full bg-accent"></span><span class="text-gray-300">Smart access and security</span></li>
                </ul>
            </div>
        </div>
    </section>

    
    <section class="py-12 bg-black/70">
        <div class="container mx-auto px-6 grid grid-cols-2 md:grid-cols-4 gap-8 text-center">
            <div><div class="text-3xl font-extrabold text-accent">50+</div><div class="text-gray-400">Premium Units</div></div>
            <div><div class="text-3xl font-extrabold text-accent">24/7</div><div class="text-gray-400">Security</div></div>
            <div><div class="text-3xl font-extrabold text-accent">10 min</div><div class="text-gray-400">From Kuza Gali</div></div>
            <div><div class="text-3xl font-extrabold text-accent">A+</div><div class="text-gray-400">Quality Build</div></div>
        </div>
    </section>

    
    <section id="booking" class="py-20 bg-neutral-900 text-center">
        <h2 class="text-3xl font-semibold text-accent mb-6">Book Your Apartment</h2>
        <p class="text-gray-300 mb-10 max-w-3xl mx-auto">
            Apply for your preferred apartment unit at The ONYX. Both Pakistani citizens and overseas Pakistanis are eligible to book.  
            Fill out your application form and submit the booking payment as per the schedule.
        </p>
        <a href="/booking" class="btn btn-primary shadow-lg shadow-accent/20">Apply Now</a>
    </section>

    
    <section id="contact" class="py-20 bg-black text-center">
        <h2 class="text-3xl text-accent font-semibold mb-6">Contact Us</h2>
        <p class="text-gray-300 mb-4">Trade Gate Office No. 1, 2nd Floor, Rizwan Plaza, Plot No. 9-W Blue Area, Islamabad</p>
        <p class="text-gray-300 mb-4">Phone: <span class="text-accent">+92 310 333 8442</span> | <span class="text-accent">+92 51 616 9199</span></p>
        <p class="text-gray-300 mb-8">Email: <a href="mailto:infopk@meer.capital" class="text-accent hover:underline">infopk@meer.capital</a></p>
        <a href="mailto:infopk@meer.capital" class="btn btn-primary">Send Inquiry</a>
    </section>

    
    <section class="py-12 bg-gradient-to-r from-accent to-orange-500 text-center">
        <h3 class="text-2xl md:text-3xl font-semibold text-white mb-4">Ready to elevate your lifestyle?</h3>
        <p class="text-white/90 mb-6">Join an exclusive community in the heart of Galiyat.</p>
        <a href="<?php echo e(route('login')); ?>" class="bg-black text-white font-semibold px-8 py-3 rounded-full hover:bg-neutral-900 transition">Start Your Reservation</a>
    </section>

    
    <footer class="py-6 bg-accent text-center text-white text-sm">
        <p>&copy; <?php echo e(date('Y')); ?> The ONYX by MEER Group. All Rights Reserved.</p>
        <a href="https://www.theonyx.pk" class="block mt-2 underline">www.theonyx.pk</a>
    </footer>

</body>
</html>
<?php /**PATH /Users/apple/Documents/onyx/resources/views/home.blade.php ENDPATH**/ ?>