<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Booking Submitted - The ONYX</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        .bg-accent { background-color: #f57c00; }
        .text-accent { color: #f57c00; }
        body { background-color:#0a0a0a; color:#fff; font-family: ui-sans-serif, system-ui, -apple-system, Segoe UI, Roboto, Helvetica, Arial; }
    </style>
    </head>
<body>
    <header class="bg-accent text-white px-6 py-4 sticky top-0 z-50 shadow">
        <div class="max-w-4xl mx-auto flex items-center justify-between">
            <a href="<?php echo e(route('home')); ?>" class="font-bold tracking-wide">THE ONYX</a>
            <a href="<?php echo e(route('booking.form')); ?>" class="underline">New Booking</a>
        </div>
    </header>
    <main class="max-w-4xl mx-auto px-6 py-16 text-center">
        <div class="text-4xl mb-4">✅</div>
        <h1 class="text-3xl font-semibold mb-2">Your booking has been submitted</h1>
        <p class="text-gray-300 mb-8">Thank you<?php echo e(isset($name) ? ', ' . e($name) : ''); ?>. Our team will contact you shortly.</p>
        <div class="mx-auto max-w-md text-left bg-black/40 border border-neutral-800 rounded-xl p-6">
            <div class="flex justify-between py-1"><span class="text-gray-400">Applicant</span><span><?php echo e(e($name ?? '—')); ?></span></div>
            <div class="flex justify-between py-1"><span class="text-gray-400">Apartment</span><span><?php echo e(e($apartment ?? '—')); ?></span></div>
        </div>
        <a href="/" class="inline-block mt-8 px-6 py-3 rounded-full bg-accent text-white">Back to Home</a>
    </main>
</body>
</html>


<?php /**PATH /Users/apple/Documents/onyx/resources/views/booking_success.blade.php ENDPATH**/ ?>