<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Approvals - The ONYX</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            darkMode: 'class',
        }
    </script>
    <style>
        .bg-accent { background: linear-gradient(to right, #22696B, #0C4C4C); }
        .text-accent { color: #22696B; }
        body { font-family: ui-sans-serif, system-ui, -apple-system, Segoe UI, Roboto, Helvetica, Arial; }
        .glass { background: rgba(255,255,255,0.03); border: 1px solid rgba(255,255,255,0.08); backdrop-filter: blur(8px); }
        .dark .glass { background: rgba(255,255,255,0.03); border: 1px solid rgba(255,255,255,0.08); }
        .light .glass { background: rgba(255,255,255,0.7); border: 1px solid rgba(0,0,0,0.1); }
        .sidebar { min-width: 260px; }
        .nav-link { display:block; padding:0.75rem 1rem; border-radius:0.75rem; transition: all .2s ease; }
        .dark .nav-link { color:#cfcfcf; }
        .light .nav-link { color:#4b5563; }
        .nav-link:hover, .nav-link.active { background-color: rgba(245,124,0,0.15); color:#fff; }
        .light .nav-link:hover, .light .nav-link.active { background-color: rgba(34, 105, 107, 0.1); color:#22696B; }
        .status-pill { display:inline-flex; align-items:center; gap:0.35rem; padding:0.25rem 0.75rem; border-radius:999px; font-size:0.75rem; }
   /* Add this to your existing styles */
.relative {
    position: relative;
}

.dropdown-menu {
    box-shadow: 0 10px 15px -3px rgba(0, 0, 0, 0.1), 0 4px 6px -2px rgba(0, 0, 0, 0.05);
}

/* Ensure the dropdown appears above the table */
table {
    position: relative;
    z-index: 1;
}
   </style>
    <script>
        // Check local storage or system preference
        if (localStorage.theme === 'dark' || (!('theme' in localStorage) && window.matchMedia('(prefers-color-scheme: dark)').matches)) {
            document.documentElement.classList.add('dark');
            document.documentElement.classList.remove('light');
        } else {
            document.documentElement.classList.remove('dark');
            document.documentElement.classList.add('light');
        }

        function toggleTheme() {
            if (document.documentElement.classList.contains('dark')) {
                document.documentElement.classList.remove('dark');
                document.documentElement.classList.add('light');
                localStorage.theme = 'light';
            } else {
                document.documentElement.classList.remove('light');
                document.documentElement.classList.add('dark');
                localStorage.theme = 'dark';
            }
        }
    </script>
</head>
<body data-require-auth="true" data-require-role="admin" class="bg-gray-50 text-gray-900 dark:bg-[#0a0a0a] dark:text-white transition-colors duration-300">
    <div class="min-h-screen flex relative">
        <!-- Mobile Sidebar Overlay -->
        <div id="sidebar-overlay" class="fixed inset-0 bg-black/80 z-40 hidden lg:hidden glass" onclick="toggleSidebar()"></div>

        <!-- Sidebar -->
        <aside id="sidebar" class="sidebar bg-white dark:bg-black/90 border-r border-gray-200 dark:border-neutral-800 p-6 fixed inset-y-0 left-0 z-50 w-64 transform -translate-x-full transition-transform duration-300 lg:translate-x-0 lg:static lg:flex flex-col">
            <div class="flex items-center justify-between mb-10">
                <div class="text-2xl font-extrabold tracking-wide">
                    <img src="/images/logo.png" alt="Onyx Admin Logo" class="h-12 block dark:hidden" style="filter: invert(1);">
                    <img src="/images/logo.png" alt="Onyx Admin Logo" class="h-12 hidden dark:block">
                </div>
                <button class="lg:hidden text-gray-400 hover:text-gray-900 dark:hover:text-white" onclick="toggleSidebar()">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                    </svg>
                </button>
            </div>
            <nav class="space-y-1 flex-1">
                <a href="<?php echo e(route('admin.dashboard')); ?>" class="nav-link">Dashboard</a>
                <a href="<?php echo e(route('admin.approvals')); ?>" class="nav-link active">Approvals</a>

                <a href="<?php echo e(route('admin.users')); ?>" class="nav-link">Users</a>
        
                <a href="<?php echo e(route('admin.settings')); ?>" class="nav-link">Settings</a>
                <a href="#" data-auth="logout" data-redirect="/login" class="nav-link">Logout</a>
            </nav>
            <div class="mt-6 glass rounded-xl p-4 bg-gray-100 dark:bg-transparent">
                <div class="text-xs uppercase text-gray-500 dark:text-gray-400">Support</div>
                <div class="text-sm mt-1 text-gray-900 dark:text-white">infopk@meer.capital</div>
            </div>
        </aside>

        <div class="flex-1 flex flex-col min-w-0">
            <header class="text-white px-4 md:px-6 py-4 flex items-center justify-between sticky top-0 z-30" style="background: linear-gradient(to right, #22696B, #0C4C4C);">
                <div class="flex items-center gap-3">
                    <button class="lg:hidden p-1 hover:bg-white/10 rounded" onclick="toggleSidebar()">
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16" />
                        </svg>
                    </button>
                    <div>
                        <h1 class="text-lg md:text-xl font-semibold">Approvals</h1>
                        <p class="text-xs md:text-sm text-white/80">Manage booking requests and approvals</p>
                    </div>
                </div>
                <div class="flex items-center gap-4">
                    <button onclick="toggleTheme()" class="p-2 rounded-full hover:bg-white/10 transition-colors">
                        <!-- Sun icon -->
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 hidden dark:block" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 3v1m0 16v1m9-9h-1M4 12H3m15.364 6.364l-.707-.707M6.343 6.343l-.707-.707m12.728 0l-.707.707M6.343 17.657l-.707.707M16 12a4 4 0 11-8 0 4 4 0 018 0z" />
                        </svg>
                        <!-- Moon icon -->
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 block dark:hidden" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20.354 15.354A9 9 0 018.646 3.646 9.003 9.003 0 0012 21a9.003 9.003 0 008.354-5.646z" />
                        </svg>
                    </button>
                <div class="hidden md:flex items-center gap-4 text-sm">
                    <a href="<?php echo e(route('booking.form')); ?>" class="underline">New Booking</a>
                    <a href="<?php echo e(route('user.documents')); ?>" class="underline">Documents</a>
                    <div class="w-8 h-8 rounded-full bg-white/20 flex items-center justify-center">A</div>
                </div>
            </header>

            <main class="p-4 md:p-6 space-y-6">
                <section class="glass rounded-xl overflow-hidden">
                    <div class="overflow-x-auto">
                        <table class="table-container min-w-[800px] w-full text-left text-sm">
                            <thead class="bg-gray-100 dark:bg-black/40 text-gray-700 dark:text-gray-300">
                                <tr>
                                    <th class="px-4 py-3">Reference</th>
                                    <th class="px-4 py-3">Applicant</th>
                                    <th class="px-4 py-3">Unit</th>
                                    <th class="px-4 py-3">Submitted</th>
                                    <th class="px-4 py-3">Status</th>
                                    <th class="px-4 py-3">Actions</th>
                                </tr>
                            </thead>
                            <tbody id="approval-table-body">
                                <script type="module">
                                    import { supabase, fetchAllBookings } from '/js/auth.js';
    
                                    document.addEventListener('DOMContentLoaded', async () => {
                                        console.log('Fetching all bookings for admin approvals...');
                                        try {
                                            const bookings = await fetchAllBookings();
                                            console.log('Bookings fetched:', bookings);
                                            const tbody = document.querySelector('#approval-table-body');
                                            tbody.innerHTML = ''; // Clear existing static rows
    
                                            if (!bookings || bookings.length === 0) {
                                                tbody.innerHTML = '<tr><td colspan="6" class="text-center py-4">No pending approvals.</td></tr>';
                                                return;
                                            }
    
                                            bookings.forEach(booking => {
                                                const row = `
                                                    <tr class="border-t border-gray-200 dark:border-neutral-800">
                                                        <td class="px-4 py-3 text-gray-900 dark:text-white">${booking.reference_no}</td>
                                                        <td class="px-4 py-3 text-gray-900 dark:text-gray-300">${booking.proposed_name}</td>
                                                        <td class="px-4 py-3 text-gray-900 dark:text-gray-300">${booking.apartment_number}</td>
                                                        <td class="px-4 py-3 text-gray-900 dark:text-white">${new Date(booking.created_at).toLocaleDateString()}</td>
                                                        <td class="px-4 py-3">
                                                            <span class="status-pill ${booking.is_approved ? 'bg-green-500/20 text-green-600 dark:text-green-400' : 'bg-yellow-500/20 text-yellow-600 dark:text-yellow-400'}">
                                                                ${booking.is_approved ? 'Approved' : 'Pending'}
                                                            </span>
                                                        </td>
                                                       <td class="px-4 py-3 relative">
                                                           <div class="relative inline-block text-left" id="dropdown-container-${booking.id}">
        <button type="button" class="inline-flex justify-between items-center w-full rounded-md border border-gray-300 dark:border-gray-600 shadow-sm px-4 py-2 bg-white dark:bg-gray-800 text-sm font-medium text-gray-700 dark:text-white hover:bg-gray-50 dark:hover:bg-gray-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-offset-gray-100 dark:focus:ring-offset-gray-800 focus:ring-indigo-500" id="menu-button-${booking.id}" onclick="toggleDropdown(event, '${booking.id}')">
            Actions
            <svg class="-mr-1 ml-2 h-5 w-5" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor">
                <path fill-rule="evenodd" d="M5.23 7.21a.75.75 0 011.06.02L10 11.168l3.71-3.938a.75.75 0 111.08 1.04l-4.25 4.5a.75.75 0 01-1.08 0l-4.25-4.5a.75.75 0 01.02-1.06z" clip-rule="evenodd" />
            </svg>
        </button>
        <div id="dropdown-${booking.id}" class="hidden dropdown-menu absolute right-0 mt-2 w-48 rounded-md shadow-lg bg-white dark:bg-gray-800 ring-1 ring-black ring-opacity-5 focus:outline-none z-50">
            <div class="py-1" role="menu" aria-orientation="vertical" aria-labelledby="menu-button-${booking.id}">
                <a href="#" class="block px-4 py-2 text-sm text-gray-700 dark:text-gray-200 hover:bg-gray-100 dark:hover:bg-gray-700" role="menuitem" onclick="viewBookingDetails(${JSON.stringify(booking).replace(/"/g, '&quot;').replace(/'/g, '&#39;')}); return false;">
                    <i class="fas fa-eye mr-2 w-4 text-center"></i> View Details
                </a>
                <a href="#" class="block px-4 py-2 text-sm text-green-600 dark:text-green-400 hover:bg-gray-100 dark:hover:bg-gray-700" role="menuitem" onclick="handleApproval('${booking.id}', true); return false;">
                    <i class="fas fa-check-circle mr-2 w-4 text-center"></i> Approve
                </a>
                <a href="#" class="block px-4 py-2 text-sm text-red-600 dark:text-red-400 hover:bg-gray-100 dark:hover:bg-gray-700" role="menuitem" onclick="handleApproval('${booking.id}', false); return false;">
                    <i class="fas fa-times-circle mr-2 w-4 text-center"></i> Reject
                </a>
            </div>
        </div>
    </div>
                                                        </td>
                                                    </tr>
                                                `;
                                                tbody.insertAdjacentHTML('beforeend', row);
                                            });
                                        } catch (error) {
                                            console.error('Error fetching and rendering bookings:', error);
                                            const tbody = document.querySelector('#approval-table-body');
                                            tbody.innerHTML = '<tr><td colspan="6" class="text-center py-4 text-red-400">Error loading bookings.</td></tr>';
                                        }
                                    });
                                </script>
                            </tbody>
                        </table>
                    </div>
                </section>
            </main>
        </div>
    </div>
    <script type="module" src="/js/auth.js"></script>
</body>
</html>

<script>
    function toggleSidebar() {
        const sidebar = document.getElementById('sidebar');
        const overlay = document.getElementById('sidebar-overlay');
        
        if (sidebar.classList.contains('-translate-x-full')) {
            // Open
            sidebar.classList.remove('-translate-x-full');
            overlay.classList.remove('hidden');
        } else {
            // Close
            sidebar.classList.add('-translate-x-full');
            overlay.classList.add('hidden');
        }
    }
</script>
<script>
// Toggle dropdown menu
    function toggleDropdown(event, id) {
        // Close all other dropdowns
        document.querySelectorAll('[id^="dropdown-"]').forEach(el => {
            if (el.id !== 'dropdown-' + id) el.classList.add('hidden');
        });

        const dropdown = document.getElementById('dropdown-' + id);
        const button = event.currentTarget; // Get the button that was clicked

        if (dropdown.classList.contains('hidden')) {
            dropdown.classList.remove('hidden');
            
            // Position the dropdown
            const rect = button.getBoundingClientRect();
            const scrollTop = window.pageYOffset || document.documentElement.scrollTop;
            const scrollLeft = window.pageXOffset || document.documentElement.scrollLeft;
            
            // Position below the button
            dropdown.style.top = (rect.bottom + scrollTop + 5) + 'px';
            
            // Align right edge of dropdown with right edge of button
            const dropdownWidth = dropdown.offsetWidth;
            dropdown.style.left = (rect.right + scrollLeft - dropdownWidth) + 'px';
        } else {
            dropdown.classList.add('hidden');
        }
    }

    // Close dropdowns when clicking outside
    document.addEventListener('click', function(event) {
        if (!event.target.closest('td')) { // specific to the table cell context
             document.querySelectorAll('[id^="dropdown-"]').forEach(el => {
                el.classList.add('hidden');
            });
        }
    });
</script><?php /**PATH /Users/apple/Documents/onyx/resources/views/admin_approvals.blade.php ENDPATH**/ ?>