<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>My Bookings - The ONYX</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            darkMode: 'class',
        }
    </script>
    <style>
        .bg-accent { background: linear-gradient(to right, #22696B, #0C4C4C); }
        .text-accent { color: #22696B; }
        body { font-family: ui-sans-serif, system-ui, -apple-system, Segoe UI, Roboto, Helvetica, Arial; }
        .glass { background: rgba(255,255,255,0.03); border: 1px solid rgba(255,255,255,0.08); backdrop-filter: blur(8px); }
        .dark .glass { background: rgba(255,255,255,0.03); border: 1px solid rgba(255,255,255,0.08); }
        .light .glass { background: rgba(255,255,255,0.7); border: 1px solid rgba(0,0,0,0.1); }
        .sidebar { min-width: 260px; }
        .nav-link { display:block; padding:0.75rem 1rem; border-radius:0.75rem; transition: all .2s ease; }
        .dark .nav-link { color:#cfcfcf; }
        .light .nav-link { color:#4b5563; }
        .nav-link:hover, .nav-link.active { background-color: rgba(245,124,0,0.15); color:#fff; }
        .light .nav-link:hover, .light .nav-link.active { background-color: rgba(34, 105, 107, 0.1); color:#22696B; }
        .status-pill { display:inline-flex; align-items:center; gap:0.35rem; padding:0.25rem 0.75rem; border-radius:999px; font-size:0.75rem; }
    </style>
    <script>
        // Check local storage or system preference
        if (localStorage.theme === 'dark' || (!('theme' in localStorage) && window.matchMedia('(prefers-color-scheme: dark)').matches)) {
            document.documentElement.classList.add('dark');
            document.documentElement.classList.remove('light');
        } else {
            document.documentElement.classList.remove('dark');
            document.documentElement.classList.add('light');
        }

        function toggleTheme() {
            if (document.documentElement.classList.contains('dark')) {
                document.documentElement.classList.remove('dark');
                document.documentElement.classList.add('light');
                localStorage.theme = 'light';
            } else {
                document.documentElement.classList.remove('light');
                document.documentElement.classList.add('dark');
                localStorage.theme = 'dark';
            }
        }
    </script>
</head>
<body data-require-auth="true" data-require-role="client" class="bg-gray-50 text-gray-900 dark:bg-[#0a0a0a] dark:text-white transition-colors duration-300">
    <div class="min-h-screen flex relative">
        <!-- Mobile Sidebar Overlay -->
        <div id="sidebar-overlay" class="fixed inset-0 bg-black/80 z-40 hidden md:hidden glass" onclick="toggleSidebar()"></div>

        <!-- Sidebar -->
        <aside id="sidebar" class="sidebar bg-white dark:bg-black/90 border-r border-gray-200 dark:border-neutral-800 p-6 fixed inset-y-0 left-0 z-50 w-64 transform -translate-x-full transition-transform duration-300 md:translate-x-0 md:static md:block">
            <div class="flex items-center justify-between mb-8">
                <div class="text-xl font-bold">
                    <img src="/images/logo.png" alt="Onyx Logo" class="h-12 block dark:hidden" style="filter: invert(1);">
                    <img src="/images/logo.png" alt="Onyx Logo" class="h-12 hidden dark:block">
                </div>
                <button class="md:hidden text-gray-400 hover:text-gray-900 dark:hover:text-white" onclick="toggleSidebar()">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                    </svg>
                </button>
            </div>
            <nav class="space-y-2">
                <a href="{{ route('dashboard') }}" class="nav-link">Overview</a>
                <a href="{{ route('user.bookings') }}" class="nav-link active">Bookings</a>
            </nav>
        </aside>

        <div class="flex-1 flex flex-col min-w-0">
            <header class="text-white px-4 md:px-6 py-4 flex items-center justify-between sticky top-0 z-30" style="background: linear-gradient(to right, #22696B, #0C4C4C);">
                <div class="flex items-center gap-3">
                    <button class="md:hidden p-1 hover:bg-white/10 rounded" onclick="toggleSidebar()">
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16" />
                        </svg>
                    </button>
                    <div>
                        <h1 class="text-lg md:text-xl font-semibold">My Bookings</h1>
                        <p class="text-xs md:text-sm text-white/80">View your booking history and status</p>
                    </div>
                </div>
                <div class="flex items-center gap-4">
                    <button onclick="toggleTheme()" class="p-2 rounded-full hover:bg-white/10 transition-colors">
                        <!-- Sun icon -->
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 hidden dark:block" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 3v1m0 16v1m9-9h-1M4 12H3m15.364 6.364l-.707-.707M6.343 6.343l-.707-.707m12.728 0l-.707.707M6.343 17.657l-.707.707M16 12a4 4 0 11-8 0 4 4 0 018 0z" />
                        </svg>
                        <!-- Moon icon -->
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 block dark:hidden" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20.354 15.354A9 9 0 018.646 3.646 9.003 9.003 0 0012 21a9.003 9.003 0 008.354-5.646z" />
                        </svg>
                    </button>
                    <div class="hidden sm:flex items-center gap-4 text-sm">
                        <a href="{{ route('booking.form') }}" class="underline">New Booking</a>
                        <a href="#" data-auth="logout" data-redirect="/login" class="underline">Logout</a>
                    </div>
                </div>
            </header>

            <main class="p-4 md:p-6 space-y-6">
                <section class="glass rounded-xl overflow-hidden">
                    <div class="overflow-x-auto">
                        <table class="w-full text-left text-sm min-w-[600px]">
                            <thead class="bg-gray-100 dark:bg-black/40 text-gray-700 dark:text-gray-300">
                                <tr>
                                    <th class="px-4 py-3">Reference</th>
                                    <th class="px-4 py-3">Unit</th>
                                    <th class="px-4 py-3">Submitted</th>
                                    <th class="px-4 py-3">Status</th>
                                    <th class="px-4 py-3">Documents</th>
                                </tr>
                            </thead>
                            <tbody id="bookings-table-body">
                                <script type="module">
                                    import { fetchUserBookings } from '/js/auth.js';

                                    document.addEventListener('DOMContentLoaded', async () => {
                                        const bookings = await fetchUserBookings();
                                        const tbody = document.querySelector('#bookings-table-body');
                                        tbody.innerHTML = ''; // Clear existing static rows

                                        if (bookings.length === 0) {
                                            tbody.innerHTML = '<tr><td colspan="5" class="text-center py-4">You have no bookings.</td></tr>';
                                            return;
                                        }

                                        bookings.forEach(booking => {
                                            const documentButton = booking.is_approved && booking.document_url
                                                ? `<div class="flex gap-2">
                                                        <a href="${booking.document_url}" target="_blank" class="text-accent underline">View</a>
                                                        <a href="${booking.document_url}" download class="text-accent underline">Download</a>
                                                   </div>`
                                                : 'N/A';

                                            const row = `
                                                <tr class="border-t border-gray-200 dark:border-neutral-800">
                                                    <td class="px-4 py-3 font-mono text-gray-900 dark:text-white">${booking.reference_no}</td>
                                                    <td class="px-4 py-3 text-gray-900 dark:text-gray-300">${booking.apartment_number}</td>
                                                    <td class="px-4 py-3 text-gray-900 dark:text-white">${new Date(booking.created_at).toLocaleDateString()}</td>
                                                    <td class="px-4 py-3">
                                                        <span class="status-pill ${booking.is_approved ? 'bg-green-500/20 text-green-600 dark:text-green-400' : 'bg-yellow-500/20 text-yellow-600 dark:text-yellow-400'}">
                                                            ${booking.is_approved ? 'Approved' : 'Pending'}
                                                        </span>
                                                    </td>
                                                    <td class="px-4 py-3 text-gray-900 dark:text-white">${documentButton}</td>
                                                </tr>
                                            `;
                                            tbody.insertAdjacentHTML('beforeend', row);
                                        });
                                    });
                                </script>
                            </tbody>
                        </table>
                    </div>
                </section>
            </main>
        </div>
    </div>
    <script type="module" src="/js/auth.js"></script>
    <script>
        function toggleSidebar() {
            const sidebar = document.getElementById('sidebar');
            const overlay = document.getElementById('sidebar-overlay');
            
            if (sidebar.classList.contains('-translate-x-full')) {
                // Open
                sidebar.classList.remove('-translate-x-full');
                overlay.classList.remove('hidden');
            } else {
                // Close
                sidebar.classList.add('-translate-x-full');
                overlay.classList.add('hidden');
            }
        }
    </script>
</body>
</html>
