<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Reports - The ONYX</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        .bg-accent { background: linear-gradient(to right, #22696B, #0C4C4C); }
        .text-accent { color: #22696B; }
        body { background-color:#0a0a0a; color:#fff; font-family: ui-sans-serif, system-ui, -apple-system, Segoe UI, Roboto, Helvetica, Arial; }
        .glass { background: rgba(255,255,255,0.03); border: 1px solid rgba(255,255,255,0.08); backdrop-filter: blur(8px); }
        .sidebar { min-width: 260px; }
        .nav-link { display:block; padding:0.75rem 1rem; border-radius:0.75rem; color:#cfcfcf; transition: all .2s ease; }
        .nav-link:hover, .nav-link.active { background-color: rgba(245,124,0,0.15); color:#fff; }
    </style>
</head>
<body data-require-auth="true" data-require-role="admin">
    <div class="min-h-screen flex relative">
        <!-- Mobile Sidebar Overlay -->
        <div id="sidebar-overlay" class="fixed inset-0 bg-black/80 z-40 hidden lg:hidden glass" onclick="toggleSidebar()"></div>

        <!-- Sidebar -->
        <aside id="sidebar" class="sidebar bg-black/90 border-r border-neutral-800 p-6 fixed inset-y-0 left-0 z-50 w-64 transform -translate-x-full transition-transform duration-300 lg:translate-x-0 lg:static lg:flex flex-col">
            <div class="flex items-center justify-between mb-10">
                <div class="text-2xl font-extrabold tracking-wide">
                    <img src="/images/logo.png" alt="Onyx Admin Logo" class="h-12">
                </div>
                <button class="lg:hidden text-gray-400 hover:text-white" onclick="toggleSidebar()">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                    </svg>
                </button>
            </div>
            <nav class="space-y-1 flex-1">
                <a href="{{ route('admin.dashboard') }}" class="nav-link">Dashboard</a>
                <a href="{{ route('admin.approvals') }}" class="nav-link">Approvals</a>

                <a href="{{ route('admin.users') }}" class="nav-link">Users</a>
                <a href="{{ route('reports') }}" class="nav-link active">Reports</a>
                <a href="{{ route('admin.settings') }}" class="nav-link">Settings</a>
                <a href="#" data-auth="logout" data-redirect="/login" class="nav-link">Logout</a>
            </nav>
            <div class="mt-6 glass rounded-xl p-4">
                <div class="text-xs uppercase text-gray-400">Support</div>
                <div class="text-sm mt-1 text-white">infopk@meer.capital</div>
            </div>
        </aside>

        <div class="flex-1 flex flex-col min-w-0">
            <header class="text-white px-4 md:px-6 py-4 flex items-center justify-between sticky top-0 z-30" style="background: linear-gradient(to right, #22696B, #0C4C4C);">
                <div class="flex items-center gap-3">
                    <button class="lg:hidden p-1 hover:bg-white/10 rounded" onclick="toggleSidebar()">
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16" />
                        </svg>
                    </button>
                    <div>
                        <h1 class="text-lg md:text-xl font-semibold">Reports</h1>
                        <p class="text-xs md:text-sm text-white/80">Track performance across bookings and assets</p>
                    </div>
                </div>
                <div class="hidden md:flex items-center gap-4 text-sm">
                    <a href="{{ route('admin.dashboard') }}" class="underline">Dashboard</a>
                    <a href="#" data-auth="logout" data-redirect="/login" class="underline">Logout</a>
                </div>
            </header>

            <main class="p-4 md:p-6 space-y-6">
                <section class="glass rounded-xl p-6">
                    <h2 class="text-lg font-semibold mb-4">Monthly Booking Summary</h2>
                    <div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-4 gap-4 text-sm">
                        <div class="border border-neutral-800 rounded-xl p-4">
                            <div class="text-gray-400">Bookings</div>
                            <div class="text-2xl font-bold text-accent mt-2">18</div>
                        </div>
                        <div class="border border-neutral-800 rounded-xl p-4">
                            <div class="text-gray-400">Revenue (PKR)</div>
                            <div class="text-2xl font-bold text-accent mt-2">32M</div>
                        </div>
                        <div class="border border-neutral-800 rounded-xl p-4">
                            <div class="text-gray-400">Cancellations</div>
                            <div class="text-2xl font-bold text-accent mt-2">2</div>
                        </div>
                        <div class="border border-neutral-800 rounded-xl p-4">
                            <div class="text-gray-400">Conversion Rate</div>
                            <div class="text-2xl font-bold text-accent mt-2">72%</div>
                        </div>
                    </div>
                </section>
                <section class="glass rounded-xl p-6">
                    <h2 class="text-lg font-semibold mb-4">Recent Reports</h2>
                    <div class="overflow-x-auto">
                        <table class="w-full text-left text-sm min-w-[600px]">
                            <thead class="bg-black/40">
                                <tr>
                                    <th class="px-4 py-3">Report</th>
                                    <th class="px-4 py-3">Author</th>
                                    <th class="px-4 py-3">Updated</th>
                                    <th class="px-4 py-3">Download</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr class="border-t border-neutral-800">
                                    <td class="px-4 py-3">Q4 Booking Performance</td>
                                    <td class="px-4 py-3 text-gray-300">Finance Team</td>
                                    <td class="px-4 py-3">Oct 12, 2025</td>
                                    <td class="px-4 py-3"><a href="#" class="underline text-accent">Download</a></td>
                                </tr>
                                <tr class="border-t border-neutral-800">
                                    <td class="px-4 py-3">Asset Availability Analysis</td>
                                    <td class="px-4 py-3 text-gray-300">Operations</td>
                                    <td class="px-4 py-3">Oct 9, 2025</td>
                                    <td class="px-4 py-3"><a href="#" class="underline text-accent">Download</a></td>
                                </tr>
                                <tr class="border-t border-neutral-800">
                                    <td class="px-4 py-3">Customer Feedback Summary</td>
                                    <td class="px-4 py-3 text-gray-300">Customer Care</td>
                                    <td class="px-4 py-3">Oct 4, 2025</td>
                                    <td class="px-4 py-3"><a href="#" class="underline text-accent">Download</a></td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </section>
            </main>
        </div>
    </div>
</body>
<script type="module" src="/js/auth.js"></script>
<script>
    function toggleSidebar() {
        const sidebar = document.getElementById('sidebar');
        const overlay = document.getElementById('sidebar-overlay');
        
        if (sidebar.classList.contains('-translate-x-full')) {
            // Open
            sidebar.classList.remove('-translate-x-full');
            overlay.classList.remove('hidden');
        } else {
            // Close
            sidebar.classList.add('-translate-x-full');
            overlay.classList.add('hidden');
        }
    }
</script>
</html>


