<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login Page</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    <style>
        .text-accent { color: #22696B; }
        .bg-accent { background: linear-gradient(to right, #22696B, #0C4C4C); }
        .hover-bg-accent:hover { background: linear-gradient(to right, #1a5456, #0a3d3d); }
        body { 
            background-color:#0a0a0a; 
            color:#e5e5e5; 
            font-family: Inter, ui-sans-serif, system-ui, -apple-system, Segoe UI, Roboto, Helvetica, Arial;
            background-image: 
                radial-gradient(900px 400px at 120% -10%, rgba(245,124,0,0.10), transparent 60%),
                radial-gradient(900px 400px at -20% -10%, rgba(245,124,0,0.08), transparent 60%);
        }
        .glass { background: rgba(255,255,255,0.04); border: 1px solid rgba(255,255,255,0.10); backdrop-filter: blur(6px); }
        .login-image {
            background: url('/images/onyx.png') no-repeat center center;
            background-size: cover;
        }
    </style>
</head>
<body data-require-auth="false" class="min-h-screen flex">
    <!-- Image Section (Hidden on mobile) -->
    <div class="hidden lg:block lg:w-1/2 login-image relative">
        <div class="absolute inset-0 bg-black/40"></div>
        <div class="absolute bottom-10 left-10 p-6 glass rounded-xl max-w-md">
            <h2 class="text-2xl font-bold text-white mb-2">Experience Luxury</h2>
            <p class="text-gray-200">Manage your premium bookings and assets with ease.</p>
        </div>
    </div>

    <!-- Login Form Section -->
    <div class="w-full lg:w-1/2 flex items-center justify-center p-6">
        <div class="w-full max-w-md glass rounded-2xl p-8 shadow-2xl">
            <div class="text-center mb-8">
                <h2 class="text-3xl font-bold text-white mb-2">Welcome back</h2>
                <p class="text-accent">Sign in to continue</p>
            </div>
            
            <form data-auth="login-form" data-redirect="/dashboard" data-role="client" class="space-y-6">
                <div>
                    <label for="email" class="block text-sm font-medium text-gray-300 mb-2">Email address</label>
                    <input type="email" id="email" name="email" required 
                        class="w-full bg-white/5 border border-white/10 rounded-lg px-4 py-3 text-white focus:outline-none focus:border-accent focus:ring-1 focus:ring-accent transition-colors">
                </div>
                
                <div>
                    <label for="password" class="block text-sm font-medium text-gray-300 mb-2">Password</label>
                    <input type="password" id="password" name="password" required 
                        class="w-full bg-white/5 border border-white/10 rounded-lg px-4 py-3 text-white focus:outline-none focus:border-accent focus:ring-1 focus:ring-accent transition-colors">
                </div>

                <div class="text-center text-red-400 text-sm hidden" data-auth-alert></div>

                <button type="submit" class="w-full bg-accent hover-bg-accent text-white font-semibold py-3 rounded-lg transition-colors shadow-lg shadow-orange-900/20">
                    Login
                </button>

                <div class="text-center mt-6">
                    <a href="{{ route('password.request') }}" class="text-sm text-gray-400 hover:text-accent transition-colors">Forgot your password?</a>
                </div>
            </form>
        </div>
    </div>
    <script type="module" src="/js/auth.js"></script>
</body>
</html>