<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Booking Submitted - The ONYX</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            darkMode: 'class',
        }
    </script>
    <style>
        .bg-accent { background: linear-gradient(to right, #22696B, #0C4C4C); }
        .text-accent { color: #22696B; }
        body { font-family: ui-sans-serif, system-ui, -apple-system, Segoe UI, Roboto, Helvetica, Arial; }
    </style>
    <script>
        // Check local storage or system preference
        if (localStorage.theme === 'dark' || (!('theme' in localStorage) && window.matchMedia('(prefers-color-scheme: dark)').matches)) {
            document.documentElement.classList.add('dark');
            document.documentElement.classList.remove('light');
        } else {
            document.documentElement.classList.remove('dark');
            document.documentElement.classList.add('light');
        }

        function toggleTheme() {
            if (document.documentElement.classList.contains('dark')) {
                document.documentElement.classList.remove('dark');
                document.documentElement.classList.add('light');
                localStorage.theme = 'light';
            } else {
                document.documentElement.classList.remove('light');
                document.documentElement.classList.add('dark');
                localStorage.theme = 'dark';
            }
        }
    </script>
    </head>
<body class="bg-gray-50 text-gray-900 dark:bg-[#0a0a0a] dark:text-white transition-colors duration-300">
    <header class="text-white px-6 py-4 sticky top-0 z-50 shadow" style="background: linear-gradient(to right, #22696B, #0C4C4C);">
        <div class="max-w-4xl mx-auto flex items-center justify-between">
            <a href="{{ route('home') }}" class="font-bold tracking-wide">THE ONYX</a>
            <div class="flex items-center gap-4">
                <button onclick="toggleTheme()" class="p-2 rounded-full hover:bg-white/10 transition-colors">
                    <!-- Sun icon -->
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 hidden dark:block" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 3v1m0 16v1m9-9h-1M4 12H3m15.364 6.364l-.707-.707M6.343 6.343l-.707-.707m12.728 0l-.707.707M6.343 17.657l-.707.707M16 12a4 4 0 11-8 0 4 4 0 018 0z" />
                    </svg>
                    <!-- Moon icon -->
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 block dark:hidden" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20.354 15.354A9 9 0 018.646 3.646 9.003 9.003 0 0012 21a9.003 9.003 0 008.354-5.646z" />
                    </svg>
                </button>
                <a href="{{ route('booking.form') }}" class="underline">New Booking</a>
            </div>
        </div>
    </header>
    <main class="max-w-4xl mx-auto px-6 py-16 text-center">
        <div class="text-4xl mb-4">✅</div>
        <h1 class="text-3xl font-semibold mb-2">Your booking has been submitted</h1>
        <p class="text-gray-600 dark:text-gray-300 mb-8">Thank you{{ isset($name) ? ', ' . e($name) : '' }}. Our team will contact you shortly.</p>
        <div class="mx-auto max-w-md text-left bg-white dark:bg-black/40 border border-gray-200 dark:border-neutral-800 rounded-xl p-6 shadow-sm dark:shadow-none">
            <div class="flex justify-between py-1"><span class="text-gray-500 dark:text-gray-400">Applicant</span><span>{{ e($name ?? '—') }}</span></div>
            <div class="flex justify-between py-1"><span class="text-gray-500 dark:text-gray-400">Apartment</span><span>{{ e($apartment ?? '—') }}</span></div>
        </div>
        <a href="/" class="inline-block mt-8 px-6 py-3 rounded-full bg-accent text-white">Back to Home</a>
    </main>
</body>
</html>


